/*
 * Decompiled with CFR 0.152.
 */
package com.andavin.images.command;

import com.andavin.images.Images;
import com.andavin.images.command.BaseCommand;
import com.andavin.images.data.DataManager;
import com.andavin.images.data.FileDataManager;
import com.andavin.images.data.MySQLDataManager;
import com.andavin.images.data.SQLiteDataManager;
import com.andavin.images.image.CustomImage;
import com.andavin.util.Logger;
import com.andavin.util.Scheduler;
import com.andavin.util.TimeoutMetadata;
import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public final class TransferCommand
extends BaseCommand {
    private static final String KEY = "transfer.check";
    private static final String[] OPTIONS = new String[]{"MySQL", "SQLite", "File"};

    public TransferCommand() {
        super("transfer", "images.command.transfer");
        this.setAliases("datatransfer");
        this.setMinimumArgs(1);
        this.setDesc("Transition all data to a different configured database");
    }

    @Override
    public void execute(Player player, String label, String[] args) {
        DataManager to;
        String type;
        if (TimeoutMetadata.isExpired(player, KEY)) {
            player.setMetadata(KEY, (MetadataValue)new TimeoutMetadata(20L, TimeUnit.SECONDS));
            player.sendMessage("\u00a7cThis may overwrite any data in the " + args[0] + " database\n\u00a7c\u00a7lThis will also stop the server");
            player.sendMessage("\u00a7eRerun the command to confirm");
            return;
        }
        player.removeMetadata(KEY, (Plugin)Images.getInstance());
        DataManager current = Images.getDataManager();
        switch (type = args[0].toUpperCase(Locale.ENGLISH)) {
            case "MYSQL": {
                if (current instanceof MySQLDataManager) {
                    player.sendMessage("\u00a7cAlready using MySQL. Please choose another...");
                    return;
                }
                FileConfiguration config = Images.getInstance().getConfig();
                to = new MySQLDataManager(config.getString("database.host"), config.getInt("database.port"), config.getString("database.schema"), config.getString("database.user"), config.getString("database.password"));
                break;
            }
            case "SQLITE": {
                if (current instanceof SQLiteDataManager) {
                    player.sendMessage("\u00a7cAlready using SQLite. Please choose another...");
                    return;
                }
                to = new SQLiteDataManager(new File(Images.getImagesDirectory(), "images.db"));
                break;
            }
            case "FILE": {
                if (current instanceof FileDataManager) {
                    player.sendMessage("\u00a7cAlready using file data. Please choose another...");
                    return;
                }
                to = new FileDataManager(new File(Images.getImagesDirectory(), "images.cimg"));
                break;
            }
            default: {
                player.sendMessage("\u00a7cUnknown database type \u00a7f" + args[0]);
                player.sendMessage("\u00a77Try MySQL or SQLite");
                return;
            }
        }
        Scheduler.async(() -> {
            player.sendMessage("\u00a7aInitializing new database...");
            to.initialize();
            List<CustomImage> images = Images.getMatchingImages(i -> true);
            images.forEach(image -> image.setId(-1));
            player.sendMessage("\u00a7aSaving \u00a7f" + images.size() + "\u00a7a to new database...");
            try {
                to.saveAll(images);
                player.sendMessage("\u00a7aSuccessfully transferred all images!");
                player.sendMessage("\u00a7eYou may now change the database configuration\n\u00a7eto the new database and restart your server");
                Logger.info("Successfully transferred all images to {}", type);
                Logger.info("You may now change the database configuration to {}", type);
            }
            catch (Exception e) {
                player.sendMessage("\u00a7cAn error occurred while transferring!");
                player.sendMessage("\u00a7eIf you are using MySQL ensure that it is configured properly.");
                player.sendMessage("\u00a7eOtherwise, contact the developer");
                Logger.severe(e);
            }
            player.sendMessage("\u00a7eShutting down in 5 seconds...");
            Scheduler.laterAsync(Bukkit::shutdown, 100L);
        });
    }

    @Override
    public void tabComplete(CommandSender sender, String[] args, List<String> completions) {
        String arg = args[0];
        for (String option : OPTIONS) {
            if (!option.regionMatches(true, 0, arg, 0, arg.length())) continue;
            completions.add(option);
        }
    }
}

